package net.w_horse.excelpojo.xml.tag;

public enum RetrieveFrom {
	NONE("none"), LEFT("left"), RIGHT("right"), BOTTOM("bottom");

	private String value;
	private RetrieveFrom(String value) {
		this.value = value;
	}
	public String getValue() {
		return this.value;
	}

	public static String getTagName() {
		return "retrieveFrom";
	}

	public static boolean equalas(RetrieveFrom elementName, String expr) {
		RetrieveFrom retrieveTypeExpr = getElement(expr);
		return (retrieveTypeExpr == elementName);
	}

	public static boolean equalsIgnoreCase(RetrieveFrom elementName, String expr) {
		RetrieveFrom retrieveTypeExpr = getElementIgnoreCase(expr);
		return (retrieveTypeExpr == elementName);
	}

	private static RetrieveFrom getElement(String elementName) {
		if (elementName.equals(LEFT.getValue())) {
			return LEFT;
		} else if (elementName.equals(RIGHT.getValue())) {
			return RIGHT;
		} else if (elementName.equals(BOTTOM.getValue())) {
			return BOTTOM;
		} else {
			return NONE;
		}
	}
	private static RetrieveFrom getElementIgnoreCase(String elementName) {
		if (elementName.equalsIgnoreCase(LEFT.getValue())) {
			return LEFT;
		} else if (elementName.equalsIgnoreCase(RIGHT.getValue())) {
			return RIGHT;
		} else if (elementName.equalsIgnoreCase(BOTTOM.getValue())) {
			return BOTTOM;
		} else {
			return NONE;
		}
	}
}
